/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.text.Collator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class VWAdminExportFileDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener {
    private Frame m_parentFrame = null;
    private VWSession m_session = null;
    private JTextField m_fileName = null;
    private JTextField m_delimeter = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private JButton m_browseButton = null;
    private JRadioButton m_tabRadioButton = null;
    private JRadioButton m_spaceRadioButton = null;
    private JRadioButton m_semicolonRadioButton = null;
    private JRadioButton m_commaRadioButton = null;
    private JRadioButton m_otherRadioButton = null;
    private boolean m_bCanceled = true;
    private FileDialog m_saveFileDialog = null;
    protected Collator collator = Collator.getInstance();

    public VWAdminExportFileDialog(VWAdminResultPane resultsPane) {
        super(resultsPane.getParentFrame());
        this.m_session = resultsPane.getSession();
        this.m_parentFrame = resultsPane.getParentFrame();
        this.init();
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        Dimension dim = VWStringUtils.stringToDimension("445,250");
        if (dim == null) {
            dim = new Dimension(400, 250);
        }
        this.setSize(dim.width, dim.height);
        this.setTitle(VWResource.s_exportTitle);
        this.setVisible(false);
        this.setLocationRelativeTo(resultsPane.getParentFrame());
        this.getContentPane().add((Component)this.createContentsPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        this.addWindowListener(new VWWindowAdapter(this));
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_okButton) {
            boolean bOkay = this.validateFields();
            if (bOkay) {
                this.m_bCanceled = false;
                this.setVisible(false);
            }
        } else if (object == this.m_cancelButton) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Admin + "bpfah032.htm");
        } else if (object == this.m_browseButton) {
            this.invokeSaveDialog();
            if (this.m_browseButton != null) {
                this.m_browseButton.requestFocus();
            }
        } else if (object == this.m_otherRadioButton) {
            this.m_delimeter.setEditable(true);
        } else if (object == this.m_spaceRadioButton || object == this.m_semicolonRadioButton || object == this.m_commaRadioButton || object == this.m_tabRadioButton) {
            this.m_delimeter.setEditable(false);
        }
    }

    public void windowClosing(WindowEvent event) {
        super.windowClosing(event);
        this.m_bCanceled = true;
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_cancelButton != null) {
            this.m_cancelButton.requestFocus();
        } else if (this.m_okButton != null) {
            this.m_okButton.requestFocus();
        } else if (this.m_helpButton != null) {
            this.m_helpButton.requestFocus();
        }
    }

    protected boolean getStatus() {
        return this.m_bCanceled;
    }

    protected String getFileName() {
        return this.m_fileName.getText();
    }

    protected String getDelimeterString() {
        if (this.m_tabRadioButton.isSelected()) {
            return new String("\t");
        }
        if (this.m_commaRadioButton.isSelected()) {
            return new String(",");
        }
        if (this.m_spaceRadioButton.isSelected()) {
            return new String(" ");
        }
        if (this.m_semicolonRadioButton.isSelected()) {
            return new String(";");
        }
        if (this.m_otherRadioButton.isSelected()) {
            return this.m_delimeter.getText();
        }
        return null;
    }

    private JPanel createContentsPanel() {
        JPanel contentsPanel = null;
        GridBagConstraints gbCons = null;
        try {
            contentsPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 2;
            gbCons.insets = new Insets(10, 5, 10, 1);
            gbCons.gridx = 0;
            gbCons.gridwidth = 1;
            gbCons.weightx = 1.0;
            contentsPanel.add((Component)this.createFilePanel(), gbCons);
            gbCons.gridx = 0;
            gbCons.gridwidth = 1;
            gbCons.weightx = 1.0;
            contentsPanel.add((Component)this.createColumnDelimeterPanel(), gbCons);
            return contentsPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createFilePanel() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        try {
            panel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.fill = 2;
            gbCons.insets = new Insets(1, 1, 1, 6);
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.weightx = 0.0;
            JLabel label = new JLabel();
            label.setText(VWResource.s_saveExportFileAs);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.s_saveExportFileAs, VWResource.s_saveExportFileAs);
            VWAccessibilityHelper.setLabelFor(label, this.m_fileName);
            VWAccessibilityHelper.setAccessibility(this.m_fileName, this, VWResource.s_fileNameTextField, VWResource.s_fileNameTextField);
            panel.add((Component)label, gbCons);
            gbCons.gridx = 0;
            gbCons.gridy = 1;
            gbCons.gridwidth = 1;
            gbCons.weightx = 1.0;
            panel.add((Component)this.m_fileName, gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.weightx = 0.0;
            panel.add((Component)this.m_browseButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_browseButton, panel, VWResource.s_browse, VWResource.s_browse);
            this.m_browseButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createColumnDelimeterPanel() {
        JPanel panel = null;
        GridBagConstraints gbCons = null;
        try {
            panel = new JPanel(new GridBagLayout());
            ButtonGroup grp = new ButtonGroup();
            grp.add(this.m_tabRadioButton);
            grp.add(this.m_commaRadioButton);
            grp.add(this.m_semicolonRadioButton);
            grp.add(this.m_spaceRadioButton);
            grp.add(this.m_otherRadioButton);
            this.m_tabRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setMemberOf(this.m_tabRadioButton, grp);
            VWAccessibilityHelper.setAccessibility(this.m_tabRadioButton, panel, VWResource.s_tab, VWResource.s_tab);
            this.m_commaRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setMemberOf(this.m_commaRadioButton, grp);
            VWAccessibilityHelper.setAccessibility(this.m_commaRadioButton, panel, VWResource.s_comma, VWResource.s_comma);
            this.m_semicolonRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setMemberOf(this.m_semicolonRadioButton, grp);
            VWAccessibilityHelper.setAccessibility(this.m_semicolonRadioButton, panel, VWResource.s_semicolon, VWResource.s_semicolon);
            this.m_spaceRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setMemberOf(this.m_spaceRadioButton, grp);
            VWAccessibilityHelper.setAccessibility(this.m_spaceRadioButton, panel, VWResource.s_space, VWResource.s_space);
            this.m_otherRadioButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setMemberOf(this.m_otherRadioButton, grp);
            VWAccessibilityHelper.setAccessibility(this.m_otherRadioButton, panel, VWResource.s_otherColon, VWResource.s_otherColon);
            panel.setLayout(new GridBagLayout());
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), VWResource.s_columnDelimeter));
            gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.fill = 2;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.insets = new Insets(1, 1, 1, 1);
            panel.add((Component)this.m_commaRadioButton, gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = -1;
            gbCons.weightx = 0.7;
            panel.add((Component)this.m_tabRadioButton, gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.weightx = 0.3;
            panel.add((Component)new JLabel(), gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 1;
            panel.add((Component)this.m_semicolonRadioButton, gbCons);
            ++gbCons.gridx;
            gbCons.gridwidth = -1;
            gbCons.weightx = 1.0;
            panel.add((Component)this.m_spaceRadioButton, gbCons);
            JPanel tinyPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.fill = 2;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 23;
            c.insets = new Insets(1, 1, 1, 1);
            tinyPanel.add((Component)this.m_otherRadioButton, c);
            ++c.gridx;
            c.gridwidth = 0;
            c.weightx = 1.0;
            tinyPanel.add((Component)this.m_delimeter, c);
            VWAccessibilityHelper.setAccessibility(this.m_delimeter, tinyPanel, VWResource.s_columnDelimeterTextField, VWResource.s_columnDelimeterTextField);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.gridwidth = 0;
            panel.add((Component)tinyPanel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = null;
        GridBagConstraints gbCons = null;
        try {
            buttonPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_okButton = new JButton(VWResource.s_OK);
            this.m_okButton.addActionListener(this);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, buttonPanel, VWResource.s_OK, VWResource.s_OK);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, buttonPanel, VWResource.s_cancel, VWResource.s_cancel);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, buttonPanel, VWResource.s_help, VWResource.s_help);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void init() {
        this.m_fileName = new JTextField();
        this.m_browseButton = new JButton(VWResource.s_browseDots);
        this.m_browseButton.addActionListener(this);
        this.m_tabRadioButton = new JRadioButton(VWResource.s_tab);
        this.m_tabRadioButton.addActionListener(this);
        this.m_commaRadioButton = new JRadioButton(VWResource.s_comma, true);
        this.m_commaRadioButton.addActionListener(this);
        this.m_semicolonRadioButton = new JRadioButton(VWResource.s_semicolon);
        this.m_semicolonRadioButton.addActionListener(this);
        this.m_spaceRadioButton = new JRadioButton(VWResource.s_space);
        this.m_spaceRadioButton.addActionListener(this);
        this.m_otherRadioButton = new JRadioButton(VWResource.s_otherColon);
        this.m_otherRadioButton.addActionListener(this);
        this.m_delimeter = new JTextField();
        this.m_delimeter.setEditable(false);
    }

    private boolean validateFields() {
        if ((this.m_fileName == null || this.m_fileName.getText().equalsIgnoreCase("")) && this.m_otherRadioButton.isSelected() && (this.m_delimeter == null || this.m_delimeter.getText().equalsIgnoreCase(""))) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_exportNeedsFileNameAndDelimeter, VWResource.s_errorMessage, 0);
            return false;
        }
        if (this.m_fileName == null || this.m_fileName.getText().equalsIgnoreCase("")) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_exportNeedsFileName, VWResource.s_errorMessage, 0);
            return false;
        }
        if (this.m_otherRadioButton.isSelected() && (this.m_delimeter == null || this.m_delimeter.getText().equalsIgnoreCase(""))) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_exportNeedsDelimeter, VWResource.s_errorMessage, 0);
            return false;
        }
        return true;
    }

    private void invokeSaveDialog() {
        if (this.m_saveFileDialog == null) {
            this.m_saveFileDialog = new FileDialog(this.m_parentFrame);
            this.m_saveFileDialog.setMode(1);
            this.m_saveFileDialog.setTitle(VWResource.s_saveStr);
        }
        String savedDir = this.m_saveFileDialog.getDirectory();
        String savedFile = this.m_saveFileDialog.getFile();
        this.m_saveFileDialog.setVisible(true);
        if (this.m_saveFileDialog.getFile() == null) {
            this.m_saveFileDialog.setDirectory(savedDir);
            this.m_saveFileDialog.setFile(savedFile);
        } else {
            this.m_fileName.setText(this.m_saveFileDialog.getDirectory() + this.m_saveFileDialog.getFile());
        }
    }
}

